﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Net;
using System.IO;
using System.Web;
using Gemini.Core.JSON.LitJson;
using PI.ZB.N1200.ELearning.BL.API.Model;

namespace PI.ZB.N1200.ELearning.BL.API
{
    public class GRequest
    {
        private Gemini.Core.BL.Base.BusinessLogicPlugIn _plugIn = null;

        /// <summary>
        /// Tworzenie Request z modulem BL zawiewrajacym prawidlowa konfiguracje
        /// </summary>
        /// <param name="PlugIn"></param>
        public GRequest(Gemini.Core.BL.Base.BusinessLogicPlugIn PlugIn)
        {
            _plugIn = PlugIn;
        }

        /// <summary>
        /// Procesuje metode API dla danego obiektu oraz typu metody
        /// </summary>
        /// <param name="InputData"></param>
        /// <param name="MethodCode"></param>
        /// <returns></returns>
        public GResponse<T> Process<T>(T InputData, MethodCodeType MethodCode)
             where T : GObject, new()
        {
            string _responseFromServer = null;
            try
            {
                string _postData = GetRequestData(InputData, MethodCode);
                byte[] byteArray = Encoding.UTF8.GetBytes(_postData);
                string serviceUrl = string.Format("{0}{1}", _plugIn.Description.Params[Dictionary.Params.APIEduFarma.ServiceURL].Value, GetMethodName<T>(InputData, MethodCode)); //"http://91.121.9.108/edufarma/api/" + GetMethodName<T>(InputData, MethodCode);
#if DEBUG
                Console.WriteLine("ServiceUrl: " + serviceUrl);
                Console.WriteLine("PostData: " + _postData);
#endif
                WebRequest request = WebRequest.Create(serviceUrl);
                request.Method = "POST";
                request.ContentType = "application/x-www-form-urlencoded";
                request.ContentLength = byteArray.Length;
                using (Stream dataStream = request.GetRequestStream())
                {
                    dataStream.Write(byteArray, 0, byteArray.Length);
                }
                using (WebResponse response = request.GetResponse())
                {
                    using (Stream responseStream = response.GetResponseStream())
                    {
                        using (StreamReader reader = new StreamReader(responseStream, Encoding.UTF8))
                        {
                            _responseFromServer = PI.ZB.N1200.ELearning.BL.API.Utils.Encoding.UnicodeToUTF8(reader.ReadToEnd());
                            GResponse<T> _response = JsonMapper.ToObject<GResponse<T>>(_responseFromServer);
                            _response.MethodCode = MethodCode;
                            _response.Raw = _responseFromServer;
                            return _response;
                        }
                    }
                }
            }
            catch (Exception except)
            {
                return new GResponse<T>() { Raw = except.Message, InternalExceptionMessage = _responseFromServer, MethodCode = MethodCode };
            }
        }

        /// <summary>
        /// Formatuje nazwe metody dla obiektu i typu metody
        /// </summary>
        /// <param name="InputData"></param>
        /// <param name="MethodCode"></param>
        /// <returns></returns>
        private string GetMethodName<T>(T InputData, MethodCodeType MethodCode)
            where T : GObject, new()
        {
            return string.Format("{0}{1}", InputData.MethodPrefix, MethodCode.ToString());
        }

        /// <summary>
        /// Przygotowuje kompletne zapytanie JSON dla danego obiektu oraz typu metody
        /// </summary>
        /// <param name="InputData"></param>
        /// <param name="MethodCode"></param>
        /// <returns></returns>
        private string GetRequestData<T>(T InputData, MethodCodeType MethodCode)
            where T : GObject, new()
        {
            string _methodName = GetMethodName<T>(InputData, MethodCode);
            string _token = Utils.MD5.Generate(string.Format("{0}{1}", _methodName, _plugIn.Description.Params[Dictionary.Params.APIEduFarma.SecretKey].Value)); //edufarma.secret.key.839102!@#45%
            string json = PI.ZB.N1200.ELearning.BL.API.Utils.Encoding.UnicodeToUTF8(JsonMapper.ToJson(InputData));
            return string.Format("api_user={0}&api_token={1}&api_version={2}&data={3}", _plugIn.Description.Params[Dictionary.Params.APIEduFarma.User].Value, _token, _plugIn.Description.Params[Dictionary.Params.APIEduFarma.Version].Value, json); //"edufarma", "0.1"
        }
    }
}